# Carbonate Equilibrium Calculator - Web Interface

A web-based interface for calculating carbonate species equilibria using the `eh22tools` library.

## Features

This calculator computes:
- **fCO₂** - Fugacity of CO₂ (µatm)
- **pH** - Hydrogen ion concentration (total pH scale)
- **CO₂** - Dissolved CO₂ and H₂CO₃ concentration (µmol kg⁻¹)
- **HCO₃⁻** - Bicarbonate concentration (µmol kg⁻¹)
- **CO₃²⁻** - Carbonate concentration (µmol kg⁻¹)
- **Ω Calcite** - Calcite saturation state
- **Ω Aragonite** - Aragonite saturation state

## Requirements

- Python 3.6+
- Flask
- NumPy

## Installation

1. Install required Python packages:
```bash
pip install flask numpy
```

Or if using conda:
```bash
conda install flask numpy
```

## Usage

1. Start the Flask server:
```bash
python3 app.py
```

2. Open your web browser and navigate to:
```
http://localhost:5000
```

3. Enter the input parameters:
   - **Salinity (S)**: Practical salinity (PSS-78 scale)
   - **Temperature (T)**: Temperature in °C (ITS-90)
   - **Pressure (P)**: Pressure in dbar (use 0 for surface)
   - **DIC**: Dissolved Inorganic Carbon in µmol kg⁻¹
   - **Alkalinity (Alk)**: Total Alkalinity in µeq kg⁻¹

4. Click "Calculate" to get the results

5. Use "Load Example Values" to see a sample calculation

## Example Values

Typical surface seawater conditions:
- Salinity: 35.0 (PSS-78)
- Temperature: 15.0 °C
- Pressure: 0 dbar
- DIC: 2100 µmol kg⁻¹
- Alkalinity: 2300 µeq kg⁻¹

## API Endpoint

The calculator also provides a REST API endpoint:

### POST `/calculate`

**Request Body:**
```json
{
    "S": 35.0,
    "T": 15.0,
    "P": 0,
    "DIC": 2100,
    "Alk": 2300
}
```

**Response:**
```json
{
    "fCO2": 380.5,
    "pH": 8.1234,
    "CO2": 12.34,
    "HCO3": 1800.56,
    "CO3": 234.67,
    "omega_cal": 4.321,
    "omega_arag": 2.789
}
```

## Files

- `app.py` - Flask web application
- `index.html` - Web interface
- `eh22tools_312.py` - Carbonate equilibrium calculation library
- `README.md` - This file

## Credits

Based on the `eh22tools` library by Roberta C. Hamme (University of Victoria), from:
*Chemical Oceanography: Element Fluxes in the Sea* (2022) by Steven R. Emerson and Roberta C. Hamme

## License

This software is licensed under Apache License 2.0
